#ifndef __SERCOSIII_MA_SVC_ERROR_H
#define __SERCOSIII_MA_SVC_ERROR_H




/////////////////////////////////////////////////////////////////////////////////////
// Sercos III - Result and Status Codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_SIII_MA_SVC_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command value.
//
#define TLR_E_SIII_MA_SVC_COMMAND_INVALID ((TLR_RESULT)0xC0710001L)

//
// MessageId: TLR_E_SIII_MA_SVC_SLAVE_HS_TIMEOUT
//
// MessageText:
//
//  Slave Service Channel Handshake timeout.
//
#define TLR_E_SIII_MA_SVC_SLAVE_HS_TIMEOUT ((TLR_RESULT)0xC0710002L)

//
// MessageId: TLR_E_SIII_MA_SVC_SLAVE_BUSY_TIMEOUT
//
// MessageText:
//
//  Slave Service Channel Busy timeout.
//
#define TLR_E_SIII_MA_SVC_SLAVE_BUSY_TIMEOUT ((TLR_RESULT)0xC0710003L)

//
// MessageId: TLR_E_SIII_MA_SVC_SLAVE_ERROR
//
// MessageText:
//
//  Slave Service Channel error.
//
#define TLR_E_SIII_MA_SVC_SLAVE_ERROR    ((TLR_RESULT)0xC0710004L)

//
// MessageId: TLR_E_SIII_MA_SVC_TRANSFER_ABORTED
//
// MessageText:
//
//  Service Channel transfer aborted.
//
#define TLR_E_SIII_MA_SVC_TRANSFER_ABORTED ((TLR_RESULT)0xC0710005L)

//
// MessageId: TLR_E_SIII_MA_SVC_INTERN_LOCKED
//
// MessageText:
//
//  Service Channels internally locked.
//
#define TLR_E_SIII_MA_SVC_INTERN_LOCKED  ((TLR_RESULT)0xC0710006L)

//
// MessageId: TLR_E_SIII_MA_SVC_MACRO_STEP_OPENIDN_FAILED
//
// MessageText:
//
//  Service Channel Macro FSM: OpenIdn failed.
//
#define TLR_E_SIII_MA_SVC_MACRO_STEP_OPENIDN_FAILED ((TLR_RESULT)0xC0710010L)

//
// MessageId: TLR_E_SIII_MA_SVC_MACRO_STEP_READATTR_FAILED
//
// MessageText:
//
//  Service Channel Macro FSM: ReadAttribute failed.
//
#define TLR_E_SIII_MA_SVC_MACRO_STEP_READATTR_FAILED ((TLR_RESULT)0xC0710011L)

//
// MessageId: TLR_E_SIII_MA_SVC_MACRO_STEP_GETLL_FAILED
//
// MessageText:
//
//  Service Channel Macro FSM: Get ListLength failed.
//
#define TLR_E_SIII_MA_SVC_MACRO_STEP_GETLL_FAILED ((TLR_RESULT)0xC0710012L)

//
// MessageId: TLR_E_SIII_MA_SVC_MACRO_STEP_ACCESSDATA_FAILED
//
// MessageText:
//
//  Service Channel Macro FSM: Data access failed.
//
#define TLR_E_SIII_MA_SVC_MACRO_STEP_ACCESSDATA_FAILED ((TLR_RESULT)0xC0710013L)

//
// MessageId: TLR_E_SIII_MA_SVC_INTERNAL_ERROR
//
// MessageText:
//
//  Internal Error.
//
#define TLR_E_SIII_MA_SVC_INTERNAL_ERROR ((TLR_RESULT)0xC0710014L)

//
// MessageId: TLR_E_SIII_MA_SVC_SLAVE_VALID_TIMEOUT
//
// MessageText:
//
//  Service Channel valid timeout.
//
#define TLR_E_SIII_MA_SVC_SLAVE_VALID_TIMEOUT ((TLR_RESULT)0xC0710015L)

//
// MessageId: TLR_E_SIII_MA_SVC_INVALID_SENDER
//
// MessageText:
//
//  Invalid Sender.
//
#define TLR_E_SIII_MA_SVC_INVALID_SENDER ((TLR_RESULT)0xC0710016L)

//
// MessageId: TLR_E_SIII_MA_SVC_ABORT_ALREADY_RUNNING
//
// MessageText:
//
//  Abort Already Running.
//
#define TLR_E_SIII_MA_SVC_ABORT_ALREADY_RUNNING ((TLR_RESULT)0xC0710017L)

//
// MessageId: TLR_E_SIII_MA_SVC_INVALID_ELEMENT
//
// MessageText:
//
//  The parameter element is wrong.
//
#define TLR_E_SIII_MA_SVC_INVALID_ELEMENT ((TLR_RESULT)0xC0710018L)

//
// MessageId: TLR_E_SIII_MA_SVC_INVALID_SLAVE_ADDRESS
//
// MessageText:
//
//  The parameter slave address is wrong.
//
#define TLR_E_SIII_MA_SVC_INVALID_SLAVE_ADDRESS ((TLR_RESULT)0xC0710019L)

//
// MessageId: TLR_E_SIII_MA_SVC_ATOMIC_TRANSFER_IN_USE
//
// MessageText:
//
//  Atomic transfer in use.
//
#define TLR_E_SIII_MA_SVC_ATOMIC_TRANSFER_IN_USE ((TLR_RESULT)0xC071001AL)

//
// MessageId: TLR_E_SIII_MA_SVC_ABORT_NOT_POSSIBLE
//
// MessageText:
//
//  Abort not possible.
//
#define TLR_E_SIII_MA_SVC_ABORT_NOT_POSSIBLE ((TLR_RESULT)0xC071001BL)

//
// MessageId: TLR_E_SIII_MA_SVC_DESTID_UNEXPECTED
//
// MessageText:
//
//  Unexpected DestId in packet.
//
#define TLR_E_SIII_MA_SVC_DESTID_UNEXPECTED ((TLR_RESULT)0xC071001CL)

//
// MessageId: TLR_E_SIII_MA_SVC_SEQUENCE_UNEXPECTED
//
// MessageText:
//
//  Unexpected sequence in packet.
//
#define TLR_E_SIII_MA_SVC_SEQUENCE_UNEXPECTED ((TLR_RESULT)0xC071001DL)

//
// MessageId: TLR_E_SIII_MA_SVC_CLOSED
//
// MessageText:
//
//  Service Channel is closed.
//
#define TLR_E_SIII_MA_SVC_CLOSED         ((TLR_RESULT)0xC071001EL)

//
// MessageId: TLR_E_SIII_MA_SVC_PARAMETER_UNEXPECTED
//
// MessageText:
//
//  SVC parameter is unexpected.
//
#define TLR_E_SIII_MA_SVC_PARAMETER_UNEXPECTED ((TLR_RESULT)0xC071001FL)

//
// MessageId: TLR_E_SIII_MA_SVC_INVALID_PRIORITY
//
// MessageText:
//
//  Invalid priority.
//
#define TLR_E_SIII_MA_SVC_INVALID_PRIORITY ((TLR_RESULT)0xC0710020L)

//
// MessageId: TLR_E_SIII_MA_SVC_INVALID_ISLIST
//
// MessageText:
//
//  IsList parameter is wrong.
//
#define TLR_E_SIII_MA_SVC_INVALID_ISLIST ((TLR_RESULT)0xC0710021L)

//
// MessageId: TLR_E_SIII_MA_SVC_MACRO_TRANSFER_IN_USE
//
// MessageText:
//
//  A macro transfer is already started.
//
#define TLR_E_SIII_MA_SVC_MACRO_TRANSFER_IN_USE ((TLR_RESULT)0xC0710022L)

//
// MessageId: TLR_E_SIII_MA_SVC_INVALID_CP
//
// MessageText:
//
//  Access the Service Channel is currently not allowed (wrong CP).
//
#define TLR_E_SIII_MA_SVC_INVALID_CP     ((TLR_RESULT)0xC0710023L)

//
// MessageId: TLR_I_SIII_MA_SVC_REQUEST_PENDING
//
// MessageText:
//
//  Internal Information: Request is pending to be started.
//
#define TLR_I_SIII_MA_SVC_REQUEST_PENDING ((TLR_RESULT)0x40710024L)

//
// MessageId: TLR_E_SIII_MA_SVC_ATTRIBUTE_NOT_ALLOWED_FOR_ELEMENT
//
// MessageText:
//
//  Attribute not allowed for element.
//
#define TLR_E_SIII_MA_SVC_ATTRIBUTE_NOT_ALLOWED_FOR_ELEMENT ((TLR_RESULT)0xC0710025L)

//
// MessageId: TLR_E_SIII_MA_SVC_INVALID_ATTRIBUTE
//
// MessageText:
//
//  Invalid attribute.
//
#define TLR_E_SIII_MA_SVC_INVALID_ATTRIBUTE ((TLR_RESULT)0xC0710026L)

//
// MessageId: TLR_E_SIII_MA_SVC_ISLIST_NOT_ALLOWED_FOR_ELEMENT
//
// MessageText:
//
//  Value of usIsList not allowed for element.
//
#define TLR_E_SIII_MA_SVC_ISLIST_NOT_ALLOWED_FOR_ELEMENT ((TLR_RESULT)0xC0710027L)

//
// MessageId: TLR_E_SIII_MA_SVC_SLAVE_NOT_AVAILABLE
//
// MessageText:
//
//  Service channel not available (Not Valid).
//
#define TLR_E_SIII_MA_SVC_SLAVE_NOT_AVAILABLE ((TLR_RESULT)0xC0710028L)




#endif  //__SERCOSIII_MA_SVC_ERROR_H

